﻿CREATE PROCEDURE [App].[NVCC_usp_GetROIAdminSearch_2_3]
	@sta3n smallint, 
	@visn smallint, 
	@startDate DateTime, 
	@endDate DateTime, 
	@userId varchar(50) = null,
	@ShowOnlyIncompleteAOD INT

	
--EXEC [App].[NVCC_usp_GetROIAdminSearch_2_3] 516,8,'03/09/2018','03/09/2018','',0
-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS

--==================================================================================
--Requestor             : RefDoc Project
--Author                : Lavanya Epuri
--Object/SP Name        : NVCC_usp_GetROIAdminSearchTest
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 12-14-2017
--
--Last Changed          : 01-08-2018
--Last Changed By		: Lavanya Epuri
--Reason For Change		: Modified the stored procedure to return dsiclosure 
--						  address details as per new requirement.

--Last Changed          : 01-09-2018
--Last Changed By		: Lavanya Epuri
--Reason For Change		: Modified the stored procedure to show a label as incomplete AOD when 
--						  disclosure made to information is not available.
--
--Last Changed          : 03-23-2018
--Last Changed By		: Lavanya Epuri
--Reason For Change		: Modified the stored procedure to show  only incomplete AOD when user
--						: clicks on the check box to view only incommplete AOD. If not list all them.
--Purpose               : To retrieve AOD details when an admin searches
--==================================================================================
IF (@userId = '')
BEGIN
SET @userId = null;
END

IF CHARINDEX('\\', @UserId) > 0 
BEGIN
	SET @UserId= REPLACE (@UserId,'\\','\')
END
--print @UserId

DECLARE @Status varchar(20)
SET @Status = 'Incomplete AOD'


BEGIN
with CTE1 (Disclosure_id, nature)
as
(

SELECT 
   disclosureid,
   STUFF((SELECT ', ' + NatureName
          FROM (
  select DisclosureId, NatureName
FROM  [App].[NVCC_DisclosureNature] DN Join [App].[NVCC_Nature] as N on  N.NatureId = DN.[NatureId]
GROUP BY dn.DisclosureId,N.[NatureName] ) d
			where nd1.DisclosureId= d.DisclosureId
          FOR XML PATH('')), 1, 1, '') [SECTORS/USERS]
FROM [App].[NVCC_DisclosureNature] nd1
group by DisclosureId

)
  select  d.DisclosureId,d.userID, 
  a.PatientName,
  VISN,
  d.Sta3n,
  StationName,
  Convert(VARCHAR(10), DateTimeOfDisclosure,101) as DateOfDisclosure,
  'Referral for Care' as StatementOfPurpose,
  CASE WHEN (ProviderNameOrGroup IS  NULL or  ProviderStreetAddress1 IS  NULL  or ProviderCity IS  NULL or  ProviderState IS  NULL or ProviderZip IS  NULL)  
  THEN @Status + CHAR(13) ELSE '' END  +
  CASE WHEN ProviderNameOrGroup IS NOT NULL THEN ProviderNameOrGroup ELSE '' END +  CHAR(13)  + 
  CASE WHEN ProviderStreetAddress1 IS NOT NULL THEN ProviderStreetAddress1 + CHAR(13)  ELSE '' END  + 
  CASE WHEN ProviderStreetAddress2 IS NOT NULL THEN ProviderStreetAddress2 + CHAR(13)ELSE '' END   +
  CASE WHEN ProviderCity IS NOT NULL THEN ProviderCity +  CHAR(13) ELSE '' END   +
  CASE WHEN ProviderState IS NOT NULL THEN ProviderState +  CHAR(13) ELSE '' END  +
  CASE WHEN ProviderZip IS NOT NULL THEN ProviderZip ELSE '' END AS DisclosureAddress,
  cte1.nature

  INTO #Temp1

  FROM [CC_REFDOC].[App].[NVCC_Disclosure] as d  INNER JOIN
   CDWWork.SPatient.SPatient a on a.PatientICN = d.PatientICN INNER JOIN
  CTE1 on CTE1.Disclosure_id = d.DisclosureId   
  WHERE d.Sta3n = CASE WHEN @sta3n > 0 THEN @sta3n ELSE d.Sta3n END
  AND d.VISN = @visn 
  AND Convert(VARCHAR(10), DateTimeOfDisclosure,101) BETWEEN @startDate AND @endDate
  AND d.UserId = ISNULL(@userId,d.UserID);

  IF (@ShowOnlyIncompleteAOD = 0)
  BEGIN
  select distinct disclosureId,ada.AccountName as UserName,
  PatientName,
  VISN,
  Sta3n,
  StationName,
  DateOfDisclosure,
  StatementOfPurpose,
  DisclosureAddress,
  nature
  from #Temp1  inner join CDWWork.NDim.ActiveDirectoryAccount AS ada on ada.FullSamAccountName = userID
 
  order by 1
   
  END

  ELSE IF(@ShowOnlyIncompleteAOD = 1)
  BEGIN 
	select distinct disclosureId,ada.AccountName as UserName,
  PatientName,
  VISN,
  Sta3n,
  StationName,
  DateOfDisclosure,
  StatementOfPurpose,
  DisclosureAddress,
  nature
  from #Temp1  inner join CDWWork.NDim.ActiveDirectoryAccount AS ada on ada.FullSamAccountName = userID
  where DisclosureAddress LIKE  '%Incomplete AOD%'
  order by 1

 
  END
   drop table #Temp1;
	
END

